﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;
using Mdws2ORM;
using BMS.Utils;

namespace BMS.VistaIntegration.Mdws.Commands.Concrete.WF
{
    public class ListPatientAppointmentFromPatientCommand
    {
        public string PatientIen { get; set; }
        public string ClinicIen { get; set; }
        public DateTime? StartTime { get; set; }
        public DateTime? EndTime { get; set; }
        public int? MaxCount { get; set; }
        private static BmsLogger logger = new BmsLogger("Vista Integration: ListPatientAppointmentFromPatientCommand:");

        private string patientIenFormat;

        private readonly ScreenPeriodBuilder screenPeriodBuilder = new ScreenPeriodBuilder()
            .Format("I {0}")
            .Variable("Y");

        private const string ClinicFormat = "I $P(^(0),U,1)={0} ";

        private string GetScreen()
        {
            return GetClinicScreen() + GetPeriodScreen();
        }

        private string GetClinicScreen()
        {
            return !string.IsNullOrEmpty(ClinicIen) ?
                string.Format(ClinicFormat, ClinicIen)
                : "";
        }

        private string GetPeriodScreen()
        {
            return screenPeriodBuilder.Build(StartTime, EndTime);
        }

        private IList<PatientAppointment> NoResult()
        {
            return new PatientAppointment[0];
        }

        private void InitStartTime(ISession session)
        {
            ListParamBuilder builder = new ListParamBuilder();
            builder.Number("1");
            builder.Index("#");
            IList<PatientAppointment> start = session.List<PatientAppointment>(builder.Build(), patientIenFormat).Select(s => s.Entity).ToList();
            if (start.Any())
            {
                StartTime = start[0].AppointmentDateTime;
            }

        }

        private void InitEndTime(ISession session)
        {
            ListParamBuilder builder = new ListParamBuilder();
            builder.Number("1");
            builder.Index("#");
            builder.AppendFlags("B");
            IList<PatientAppointment> end = session.List<PatientAppointment>(builder.Build(), patientIenFormat).Select(s => s.Entity).ToList();
            if (end.Any())
            {
                EndTime = end[0].AppointmentDateTime.AddSeconds(1);
            }
        }

        public IList<PatientAppointment> Execute(ISession session)
        {
            patientIenFormat = string.Format(",{0},", PatientIen);
            if (!StartTime.HasValue)
                InitStartTime(session);
            if (!EndTime.HasValue)
                InitEndTime(session);

            if (!StartTime.HasValue || !EndTime.HasValue || StartTime.Value > EndTime.Value)
                return NoResult();

            ListParamBuilder builder = new ListParamBuilder()
                .Screen(GetScreen());
            if (MaxCount.HasValue)
                builder.Number(MaxCount.Value.ToString());

            List<PatientAppointment> result = new List<PatientAppointment>();

            Patient patient = session.Get<Patient>(GetParamBuilder.DefaultParam, PatientIen);

            DateTime fromDate = StartTime.Value.AddSeconds(-1);
            string from = fromDate.Month == StartTime.Value.Month ?
                Converters.ToInternalFormat(fromDate) : "";
            builder.Partial(ParamUtilities.GetMonthPart(StartTime.Value));
            builder.From(from);
            result.AddRange(session.GetSubEntities<PatientAppointment, Patient>(builder.Build(), patient, patientIenFormat));
            logger.LogFormat(BmsLogger.Level.Info, "ListPatientAppointmentFromPatientCommand - Execute: count - {0}", result.Count);
            return result;
        }
    }
}
